VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cRamp"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Segments As cpSegmentShapeCollection

Public Sub Construct(ByVal X1 As Double, ByVal Y1 As Double, ByVal X3 As Double, ByVal Y3 As Double, Optional ByVal Thickness = 2)
Dim S As cpSegmentShape
  
  With PhEngine.ConstructionCC
    'here we draw a simple Bezier-Curve, to construct our Ramp
    .CurveTo X1, Y1, X1 + (X3 - X1) * 0.6, Y3 + 180, X3, Y3
    .ClearPath True
    .CurveTo X3 + 270, Y1, X1 + (X3 - X1) * 0.7, Y3 + 180, X3 + 7, Y3 + 7
    
    'same call as within the construction of cOuterBorder (splitting the curved-path up into Segments)
    Set Segments = PhEngine.StaticBody.CreateSegmentShapeCollectionFromPath(.CopyPath(True, 0.5), Thickness)
  End With

  For Each S In Segments
    PhEngine.Space.AddStaticShape S, 0.3, 0.4
  Next S
End Sub

Public Sub Draw(CC As cCairoContext)
Dim S As cpSegmentShape
  CC.Save
  
    For Each S In Segments
      CC.DrawLine S.A_X, S.A_Y, S.B_X, S.B_Y
    Next S
    
    CC.SetLineWidth Segments.Thickness + 1
    CC.SetSourceColor &HFFE0E0
    CC.Stroke
    
  CC.Restore
End Sub

